from typing import Any
from PIL import Image
from abc import abstractmethod

class BaseLLM:
    def __init__(self, use_gpu=True):
        raise NotImplementedError

    def load_model(self):
        raise NotImplementedError

    def infer(self, image: Image, prompt: str) -> str:
        raise NotImplementedError

