from typing import Optional

from pydantic import BaseModel
from datetime import datetime

class UserProfile(BaseModel):
    user_id: str
    email: str
    username: str

    first_name: Optional[str] = None
    last_name: Optional[str] = None


class User(UserProfile):
    user_id: str

    email_verified: bool
    disabled: bool
    
    org_id: Optional[str] = None


class UserWithPassword(User):
    password: str

    def downgrade(self) -> User:
        """
        Removes the password fields and returns to the original user object

        :return: User object
        :rtype: User
        """
        return User.model_validate(self.model_dump())


class UserSession(BaseModel):
    session_id: str

    token: str
    expires: datetime
    owner: str
    active: bool
