from typing import Optional
from pydantic import BaseModel
from enum import Enum
from datetime import datetime


class APITierEnum(str, Enum):
    free = 'free'
    paid = 'paid'
    admin = 'admin'


class APIKey(BaseModel):
    key_id: Optional[str] = None
    key_secret: Optional[str] = None

    owner: str
    active: bool
    tier: APITierEnum
    created: datetime

    notes: Optional[str] = None
    internal: Optional[bool] = None

class APIKeyCreationRequest(BaseModel):
    tier: APITierEnum
    notes: str
