from typing import Optional

from pydantic import BaseModel
from datetime import datetime

class UserProfile(BaseModel):
    user_id: str
    email: str
    username: str

    first_name: Optional[str]
    last_name: Optional[str]


class User(UserProfile):
    user_id: str

    email_verified: bool
    disabled: bool
    
    org_id: Optional[str]


class UserWithPassword(User):
    password: str

    def downgrade(self) -> User:
        """
        Removes the password fields and returns to the original user object

        :return: User object
        :rtype: User
        """
        return User.parse_obj(self.dict())


class UserSession(BaseModel):
    session_id: str

    token: str
    expires: datetime
    owner: str
    active: bool
