from datetime import datetime
from typing import List

from pydantic import BaseModel

from .base import Image, Asset, Order
from .user import User

class AssetAccess(BaseModel):
    iaa_id: str
    api_key: str
    asset_id: str

    access_time: datetime


class LineageReport(BaseModel):
    order: Order
    image: Image
    user: User
    assets: List[Asset]
    accesses: List[AssetAccess]

    docs: str
