from typing import Optional
from pydantic import BaseModel
from enum import Enum
from datetime import datetime


class APITierEnum(str, Enum):
    free = 'free'
    paid = 'paid'
    admin = 'admin'


class APIKey(BaseModel):
    key_id: Optional[str]
    key_secret: Optional[str]

    owner: str
    active: bool
    tier: APITierEnum
    created: datetime

    notes: Optional[str]
    internal: Optional[bool]

class APIKeyCreationRequest(BaseModel):
    tier: APITierEnum
    notes: str
