# goose

A swiss army knife for managing AWS instances with spacerake. Spiritually inspired by LV's `dux`.

capabilities:

- fleet configuration
    - list/turn on/turn off ec2 instances
    - configure elastic IPs to machines
    - configure route53 domain names to machines
    - provide initial configuration to machines
- per-project configuration
    - configure projects via per-project `goose.toml` options
    - copy git repos and files to remote machines
    - run tasks on machines

known issues:

- `git-lfs` is not supported

## getting started

```
$ pipx install --index-url https://py.pkg.spacerake.net/simple/ goose
$ flock login
```

## some example tasks

### fleet management

List all EC2 instances:

```
$ flock list
```

List machines in a project:

```
$ flock list --project srai
```

Assign a `Hostname` tag to an instance named `HOST`:

```
$ flock hostname HOST
```

Assign all hosts with a hostname tag to a subdomain on `machines.spacerake.net`, creating elastic IPs where necessary:

```
$ flock dns-sync
```

### project management

All the following require a `goose.toml` in your project directory.


Set up deploying to a remote host in a `goose.toml`:

```
$ goose install-remote HOST
```

Push a git repo with a `goose.toml` to a specified host:

```
$ goose push HOST
```

Connect to a host:

```
$ goose connect HOST
```

Run a task on a host:

```
$ goose run HOST TASK
```

## config files

example global config (created automatically by `goose login`):

```toml
# goose example global configuration

[gitlab]
url = 'https://gitlab.learn.ventures'
token = 'abcdefghijklmnopqrstuvwxyz'

[aws]
access_token = 'abcdefghijklmnopqrstuvwxyz'
access_secret = 'abcdefghijklmnopqrstuvwxyz'
default_region = 'us-west-2'
```

example goose local config:

```toml
# goose example local configuration

[repo]
repository = 'spacerake/srai-fisi'
name = 'srai-fisi'
extra_files = [
    '.env'
]

[hosts.ml01]
user = 'ec2-user'
remote = 'ml01.machines.spacerake.net'

[hosts.unpack]
user = 'ec2-user'
remote = 'unpack.machines.spacerake.net'

[hosts.unpack.tasks]
install-python = [
    'sudo yum install -y python3.11 python3.11-pip-wheel',
    'python3 -m ensurepip'
]


[tasks]
ls = 'ls -a'
multiple = [
    'ls -a',
    'echo foo bar baz'
]
```

## contributing

Build and publish a package:

```
$ make publish
```
